/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm2212;

import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.modelgen.ConfigChangeDetector;
import ibm.nways.jdm.modelgen.LocalModel;
import ibm.nways.ras.RAS;
import java.util.Vector;

public class SlotChangeDetector
implements ConfigChangeDetector {
    private static final int RASID = 19;
    private static final int RASSUB = 15;
    Vector adapterInfos;

    public Vector getAdapTable(LocalModel localModel) {
        Vector vector;
        String string = "getAdapTable";
        if (RAS.isEnabled(19, 15)) {
            RAS.enter(19, 15, this, string);
        }
        try {
            LocalModel localModel2 = localModel.getComponent("ConfigurationFolder");
            LocalModel localModel3 = localModel2.getComponent("SystemFolder");
            LocalModel localModel4 = localModel3.getComponent("DeviceFolder");
            LocalModel localModel5 = localModel4.getComponent("Ibm2212Adap");
            vector = localModel5.getRestOfInfo("Panel", "default", null, null);
        }
        catch (Exception exception) {
            if (RAS.isEnabled(19, 15)) {
                RAS.trace(19, 15, this, string, "Timeout:");
            }
            vector = null;
        }
        return vector;
    }

    public void init(LocalModel localModel) {
        if (RAS.isEnabled(19, 15)) {
            RAS.enter(19, 15, this, "init");
        }
        this.adapterInfos = this.getAdapTable(localModel);
    }

    public boolean configChanged(LocalModel localModel) {
        String string = "configChanged";
        if (this.adapterInfos == null) {
            if (RAS.isEnabled(19, 15)) {
                RAS.trace(19, 15, this, string, "adapterInfos == null");
            }
            this.adapterInfos = this.getAdapTable(localModel);
            return false;
        }
        Vector vector = this.getAdapTable(localModel);
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                ModelInfo modelInfo = (ModelInfo)vector.elementAt(n);
                ModelInfo modelInfo2 = (ModelInfo)this.adapterInfos.elementAt(n);
                if (modelInfo.timeoutDetected || modelInfo2.timeoutDetected) {
                    return false;
                }
                int n2 = (Integer)modelInfo.get("Panel.Ibm2212AdapType");
                int n3 = (Integer)modelInfo2.get("Panel.Ibm2212AdapType");
                if (RAS.isEnabled(19, 15)) {
                    RAS.trace(19, 15, this, string, "Types are  " + n2 + "  " + n3);
                }
                if (n2 != n3) {
                    this.adapterInfos = vector;
                    if (RAS.isEnabled(19, 15)) {
                        RAS.trace(19, 15, this, string, "Types are different = " + n2 + "  " + n3);
                    }
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public void dispose() {
        this.adapterInfos = null;
    }
}

